// Money filter by Giacomo Preciado
// Based on: "Free Engraved Illustration Effect Action for Photoshop" - http://snip.ly/j0gq
// e-mail: giacomo@kyrie.pe
// website: http://kyrie.pe

vec4 FUNCNAME(vec2 tc) 
{
	vec4 c = INPUT(tc);
    int alpha = PREFIX(alpha);
    int amplitud = PREFIX(amplitud);
    float amp = float(amplitud)/100.0;
    float frecuencia = PREFIX(frecuencia);   
    float gris = 1.0;
	float factor = iResolution.x/640.0;
    float divisor = (4.8 / iResolution.y) * factor;
    float grosorInicial = divisor * 0.2;
    
    const int kNumPatrones = 6;
    vec3 datosPatron[kNumPatrones];
    datosPatron[0] = vec3(-0.7071, 0.7071, 3.0); // -45
    datosPatron[1] = vec3(0.0, 1.0, 0.6); // 0
    datosPatron[2] = vec3(0.0, 1.0, 0.5); // 0
    datosPatron[3] = vec3(1.0, 0.0, 0.4); // 90
    datosPatron[4] = vec3(1.0, 0.0, 0.3); // 90
    datosPatron[5] = vec3(0.0, 1.0, 0.2); // 0

    vec4 color = c;
    vec4 fragColor = color;
     for(int i = 0; i < kNumPatrones; i++)
    {
        float coseno = datosPatron[i].x;
        float seno = datosPatron[i].y;
        
        // RotaciÃ³n del patrÃ³n
        vec2 punto = vec2(
            tc.x * coseno - tc.y * seno,
            tc.x * seno + tc.y * coseno
        );

        float grosor = grosorInicial * float(i + 1);
        float dist = mod(punto.y + grosor * 0.5 - sin(punto.x * frecuencia) * amp, divisor);
        float brillo = 0.3 * color.r + 0.4 * color.g + 0.3 * color.b;

        if(dist < grosor && brillo < 0.75 - 0.12 * float(i))
        {
            // Suavizado
            float k = datosPatron[i].z;
            float x = (grosor - dist) / grosor;
            float fx = abs((x - 0.5) / k) - (0.5 - k) / k; 
            gris = min(fx, gris);
        }
    }
    fragColor = vec4(gris,gris,gris,c.w);
    return mix( fragColor, c, 1.0 - float(alpha)/100.0 );   
}